set autoscale 
set xtic auto 
set ytic auto 
set style line  1 lt 1 lw 1 lc rgb "#000000"
set style line  2 lt 1 lw 1 lc rgb "#FF0000"
set style line  3 lt 1 lw 3 lc rgb "#000000"

set xlabel "E (eV)" font "Times,12"
set ylabel "Intensity (arb. units)" font "Times,8"

set out 'XASSpec.ps'
set size 1.0, 1.0
set terminal postscript landscape enhanced color  "Times" 8

set xrange [8332.5:8335]

energyshift=8331

set multiplot layout 5, 3

plot "XASSpec.dat"  u ($1+energyshift):(-$3 ) title '  yz-polarized Sz=-1' with lines ls  1
plot "XASSpec.dat"  u ($1+energyshift):(-$5 ) title '  yz-polarized Sz= 0' with lines ls  1
plot "XASSpec.dat"  u ($1+energyshift):(-$7 ) title '  yz-polarized Sz= 1' with lines ls  1
plot "XASSpec.dat"  u ($1+energyshift):(-$9 ) title '  xz-polarized Sz=-1' with lines ls  1
plot "XASSpec.dat"  u ($1+energyshift):(-$11) title '  xz-polarized Sz= 0' with lines ls  1
plot "XASSpec.dat"  u ($1+energyshift):(-$13) title '  xz-polarized Sz= 1' with lines ls  1
plot "XASSpec.dat"  u ($1+energyshift):(-$15) title '  xy-polarized Sz=-1' with lines ls  1
plot "XASSpec.dat"  u ($1+energyshift):(-$17) title '  xy-polarized Sz= 0' with lines ls  1
plot "XASSpec.dat"  u ($1+energyshift):(-$19) title '  xy-polarized Sz= 1' with lines ls  1
plot "XASSpec.dat"  u ($1+energyshift):(-$21) title 'x2y2-polarized Sz=-1' with lines ls  1
plot "XASSpec.dat"  u ($1+energyshift):(-$23) title 'x2y2-polarized Sz= 0' with lines ls  1
plot "XASSpec.dat"  u ($1+energyshift):(-$25) title 'x2y2-polarized Sz= 1' with lines ls  1
plot "XASSpec.dat"  u ($1+energyshift):(-$27) title '  z2-polarized Sz=-1' with lines ls  1
plot "XASSpec.dat"  u ($1+energyshift):(-$29) title '  z2-polarized Sz= 0' with lines ls  1
plot "XASSpec.dat"  u ($1+energyshift):(-$31) title '  z2-polarized Sz= 1' with lines ls  1

unset multiplot

set xrange [8330:8336]

intensityscale=64

plot "XASSpec.dat" using ($1+energyshift):((-$3-$9-$15-$21-$27) * intensityscale) title 'isotropic theory' with lines ls 1


set size 1.0, 0.6
intensityscale=48
set out 'XASIsoSpec.ps'

plot "XASIsoSpec.dat" using ($1+energyshift):((-$3) * intensityscale) title 'isotropic theory' with lines ls 3

